(function ($, Drupal, once, drupalSettings) {
  Drupal.behaviors.notifyJs = {
    attach: function (context, settings) {
      once('.path-notify-manager', 'body', context).forEach(function (element) {
        var mode = $('input[name="field_notification_mode"]:checked').val();
        $('.field--name-field-notification-groups, .field--name-field-notification-users').addClass('hidden');
        if (mode == 'groups') {
          $('.field--name-field-notification-groups').removeClass('hidden');
        }
        if (mode == 'users') {
          $('.field--name-field-notification-users').removeClass('hidden');
        }
        $('input[name="field_notification_mode"]').change(function() {
          $('.field--name-field-notification-groups, .field--name-field-notification-users').addClass('hidden');
          if ($(this).val() == 'groups') {
            $('.field--name-field-notification-groups').removeClass('hidden');
          }
          if ($(this).val() == 'users') {
            $('.field--name-field-notification-users').removeClass('hidden');
          }
        });
      });
    }
  };
})(jQuery, Drupal, once, drupalSettings);