<?php

namespace Drupal\notify_manager\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Notify manager type configuration entity.
 *
 * @ConfigEntityType(
 *   id = "notify_manager_type",
 *   label = @Translation("Notify manager type"),
 *   label_collection = @Translation("Notify manager types"),
 *   label_singular = @Translation("notify manager type"),
 *   label_plural = @Translation("notify managers types"),
 *   label_count = @PluralTranslation(
 *     singular = "@count notify managers type",
 *     plural = "@count notify managers types",
 *   ),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\notify_manager\Form\NotifyManagerTypeForm",
 *       "edit" = "Drupal\notify_manager\Form\NotifyManagerTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\notify_manager\NotifyManagerTypeListBuilder",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     }
 *   },
 *   admin_permission = "administer notify manager types",
 *   bundle_of = "notify_manager",
 *   config_prefix = "notify_manager_type",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/notify_manager_types/add",
 *     "edit-form" = "/admin/structure/notify_manager_types/manage/{notify_manager_type}",
 *     "delete-form" = "/admin/structure/notify_manager_types/manage/{notify_manager_type}/delete",
 *     "collection" = "/admin/structure/notify_manager_types"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid",
 *   }
 * )
 */
class NotifyManagerType extends ConfigEntityBundleBase {

  /**
   * The machine name of this notify manager type.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable name of the notify manager type.
   *
   * @var string
   */
  protected $label;

}
