<?php

namespace Drupal\notify_manager\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the notify manager entity edit forms.
 */
class NotifyManagerForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New notify manager %label has been created.', $message_arguments));
        $this->logger('notify_manager')->notice('Created new notify manager %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The notify manager %label has been updated.', $message_arguments));
        $this->logger('notify_manager')->notice('Updated notify manager %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.notify_manager.canonical', ['notify_manager' => $entity->id()]);

    return $result;
  }

}
