<?php

namespace Drupal\notify_manager;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of notify manager type entities.
 *
 * @see \Drupal\notify_manager\Entity\NotifyManagerType
 */
class NotifyManagerTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['title'] = $this->t('Label');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No notify manager types available. <a href=":link">Add notify manager type</a>.',
      [':link' => Url::fromRoute('entity.notify_manager_type.add_form')->toString()]
    );

    return $build;
  }

}
