<?php declare(strict_types = 1);

namespace Drupal\notify_widget\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;
use Drupal\notify_widget\NotifyWidgetApi;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * @todo Add a description for the form.
 */
final class DeleteAllNotificationsConfirmForm extends ConfirmFormBase {

  /**
   * The notification ID from the route parameters.
   *
   * @var int
   */
  protected $notificationId;

  /**
   * Class constructor.
   *
   * @param \Drupal\notify_widget\NotifyWidgetApi $notifyWidgetApi
   *   The notify widget API service.
   */
  public function __construct(
    protected readonly NotifyWidgetApi $notifyWidgetApi
  ) {}

  /**
   * Class creator.
   */
  public static function create(ContainerInterface $container) {
    return new self(
      $container->get('notify_widget.api')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'notify_widget_delete_all_notification_confirm';
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): TranslatableMarkup {
    return $this->t('Are you sure you want to delete all your notifications?');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl(): Url {
    return new Url('notify_widget.notifications', [
      'user' => $this->currentUser()->id(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    return parent::buildForm($form, $form_state); // TODO: Change the autogenerated stub
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    // Delete the notification using the notify_widget.api service.
    $uid=$this->currentUser()->id();
    $this->notifyWidgetApi->deleteAllNotificationsByUserId((int)$uid);
    $this->notifyWidgetApi->clearNotifyWidgetCacheForUser();
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
