## INTRODUCTION

Provides a simple, HTML native slider input Field Widget for Number fields. Utilizes the native range HTML input, with no javascript libraries. There is an optional, small, javascript snippet that can be added to display the slider values, as that is not natively supported.

The slider supports:

- integer, decimal, and float field types.
- Using the field's max and minimum values.
- A configurable step value.
- Optionally, can be configured to allow for displaying the value of the slider, as the user interacts with it. This adds a small Javascript snippet for that effect.
- Using the prefix and suffix values for the field, when displaying the values.
- For decimal values, allows for configuring wether the value is a percentage. This multiplies the value by 100, when displaying the values. Does not actually change the field value that is submitted.

## REQUIREMENTS

This module has no external dependencies beyond Drupal core.

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## CONFIGURATION

After installation, the Number Range Slider widget becomes available for integer, decimal, and float fields:

1. **Field Configuration**: When editing a field, select "Number Slider" as the widget type.
2. **Widget Settings**: Configure the step value, display value option, and percentage display.
3. **Field Settings**: Set minimum/maximum values, prefix, and suffix in the field configuration.
4. **Content Creation**: Use the slider widget when creating or editing content.

## MAINTAINERS

Current maintainers:
[gueguerreiro](https://drupal.org/user/gueguerreiro)

- [Project page](https://www.drupal.org/project/number_range_slider/)
- [Issue queue](https://www.drupal.org/project/issues/number_range_slider)

