/**
 * @file
 * Range slider behavior.
 */
(function (Drupal, once, drupalSettings) {

  'use strict';

  /**
   * Process ranges_slider elements.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.rangeSlider = {
    attach: function attach(context, settings) {
      const sliders = once('range-sliders', document.querySelectorAll('.form-type--range'), context);
      sliders.forEach(element => {
        // Add output next to range slider input.
        var input = element.querySelector(".slider-input");
        var value = getValue(input.value, settings);
        var output = document.createElement('p');
        output.className = 'slider-output';
        output.textContent = Drupal.t("Value: @value", {"@value": value});
        input.insertAdjacentElement('afterend', output);

        // Event to update text value as slider input changes.
        input.addEventListener("input", (event) => {
          var input = event.target;
          var output = input.parentElement.querySelector('.slider-output');
          var value = getValue(input.value, settings);

          output.textContent = Drupal.t("Value: @value", {"@value": value});
        });
      });
    }

  }

  function getValue(value, settings) {
    if (settings.number_range_slider.isPercentage) {
      value = value * 100;
    }
    if (settings.number_range_slider.prefix) {
      value = settings.number_range_slider.prefix + value;
    }
    if (settings.number_range_slider.suffix) {
      value = value + settings.number_range_slider.suffix;
    }

    return value;
  }

})(Drupal, once, drupalSettings);
