(function ($, Drupal, once) {

  'use strict';

  /**
   * Fetches publications from the server and renders them.
   */
  Drupal.behaviors.getPublications = {
    attach: function (context) {
      once('getPublications', 'body', context).forEach(function () {
        $.ajax({
          url: Drupal.url('ajax-response'),
          type: 'POST',
          dataType: 'json',
          data: {
            nva: drupalSettings.nva
          },
          success: function (response) {
            $("#nva_publications_ajax").html(response);
          }
        });
      });
    }
  };

})(jQuery, Drupal, once);
