<?php

declare(strict_types=1);

namespace Drupal\nva\Controller;

use Drupal\Core\Controller\ControllerBase;
use Stinis\Nva\APIClient;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns Ajax response for Ajax route.
 */
class AjaxController extends ControllerBase {

  /**
   * The NVA API client.
   *
   * @var \Stinis\Nva\APIClient
   */
  private APIClient $apiClient;

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('nva.api_client'),
    );

  }

  public function __construct(APIClient $apiClient) {
    $this->apiClient = $apiClient;
  }

  public function getPublications(): JsonResponse {
    $totalHits = 0;
    $publications = [];
    // Get Post data.
    $request = \Drupal::request();
    $nvaSetting = $request->request->all()['nva'];
    $page = $nvaSetting['page'] ?? 0;

    $person = $this->apiClient->getCristinPersonByQueryParameters(['name' => $nvaSetting['authorName']]);
    if (isset($person['hits'][0])) {
      // If the person is found, get the person ID.
      $personID = $person['hits'][0]['id'];
      // Set default query parameters used for all requests.
      $queryParameters = [
        'contributor' => $personID,
        'results' => 1000,
      ];
      if (!empty($nvaSetting['sortBy'])) {
        //$queryParameters['sort'] = $nvaSetting['sortBy'] . ':asc' ?? 'published_date:asc';
      }
      // Add categories filter to query parameters if any are selected.
      if (!empty($nvaSetting['categories'])) {
        $queryParameters['category_should'] = implode(',', $nvaSetting['categories']);
      }

      if (!empty($nvaSetting['resultsPerPage'])) {
        $queryParameters['from'] = $nvaSetting['resultsPerPage'] * ($page);
        $queryParameters['size'] = $nvaSetting['resultsPerPage'];
      }

      // Get publications from the API.
      $results = $this->apiClient->searchPublications($queryParameters);
      $totalHits = $results['totalHits'];
      $publications = $results['hits'];
    }

    $publicationsRender = [
      '#theme' => 'publications_list_ajax',
      '#publications' => $publications,
      '#totalHits' => $totalHits,
    ];

    $response = \Drupal::service('renderer')->render($publicationsRender);
    return new JsonResponse($response);
  }

}
