<?php

namespace Drupal\nva\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\key\Entity\Key;

class NvaSettingsForm extends ConfigFormBase {
  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'nva_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['nva.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('nva.settings');

    $key_options = [];
    foreach (Key::loadMultiple() as $key) {
      $key_options[$key->id()] = $key->label();
    }

    $form['nva_hostname'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Hostname'),
      '#default_value' => $config->get('nva_hostname'),
      '#required' => TRUE,
    ];

    $form['nva_token_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Token URL'),
      '#default_value' => $config->get('nva_token_url'),
      '#required' => TRUE,
    ];

    $form['nva_client_id'] = [
      '#type' => 'key_select',
      '#title' => $this->t('Client ID'),
      '#default_value' => $config->get('nva_client_id'),
      '#states' => [
        'required' => [
          ':input[name="use_gravitee"]' => ['checked' => FALSE],
        ],
        'visible' => [
          ':input[name="use_gravitee"]' => ['checked' => FALSE],
        ],
      ],
    ];

    $form['nva_client_secret'] = [
      '#type' => 'key_select',
      '#title' => $this->t('Client Secret'),
      '#default_value' => $config->get('nva_client_secret'),
      '#states' => [
        'required' => [
          ':input[name="use_gravitee"]' => ['checked' => FALSE],
        ],
        'visible' => [
          ':input[name="use_gravitee"]' => ['checked' => FALSE],
        ],
      ],
    ];

    $form['use_gravitee'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use Gravitee API Key'),
      '#default_value' => $config->get('use_gravitee'),
      '#description' => $this->t('Check this box to use a Gravitee API key instead of Client ID/Secret.'),
    ];

    $form['gravitee_key'] = [
      '#type' => 'select',
      '#title' => $this->t('Gravitee API Key'),
      '#options' => $key_options,
      '#default_value' => $config->get('gravitee_key'),
      '#required' => FALSE,
      '#states' => [
        'visible' => [
          ':input[name="use_gravitee"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['key_info'] = [
      '#type' => 'markup',
      '#markup' => $this->t('To create keys for client id, secret og gravitee, go to <a href=":url" target="_blank">Keys create page</a>.', [':url' => '/admin/config/system/keys']),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('nva.settings')
      ->set('nva_hostname', $form_state->getValue('nva_hostname'))
      ->set('nva_token_url', $form_state->getValue('nva_token_url'))
      ->set('nva_client_id', $form_state->getValue('nva_client_id'))
      ->set('nva_client_secret', $form_state->getValue('nva_client_secret'))
      ->set('nva_key', $form_state->getValue('nva_key'))
      ->set('use_gravitee', $form_state->getValue('use_gravitee'))
      ->set('gravitee_key', $form_state->getValue('gravitee_key'))
      ->save();
    parent::submitForm($form, $form_state);
  }
}
