<?php

namespace Drupal\nva\Service;

use Drupal\key\Entity\Key;
use Drupal\Core\Config\ConfigFactoryInterface;
use Stinis\Nva\APIClient;

class ApiClientConfigurator {
  /**
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * Returns a configured APIClient instance based on settings.
   *
   * @return APIClient
   */
  public function getConfiguredApiClient() {
    $config = $this->configFactory->get('nva.settings');
    if ($config->get('use_gravitee')) {
      // Use default APIClient (no client_id/secret needed)
      $apiClient = new APIClient('','','https://gw-uib.intark.uh-it.no/nva/');
      $gravitee_key_id = $config->get('gravitee_key');
      if ($gravitee_key_id) {
        $key = Key::load($gravitee_key_id);
        if ($key) {
          $apiClient->setHeaders([
            'X-Gravitee-Api-Key' => $key->getKeyValue(),
          ]);
        }
      }
    } else {
      $client_id = Key::load($config->get('nva_client_id'))->getKeyValue();
      $client_secret = Key::load($config->get('nva_client_secret'))->getKeyValue();
      $tokenUrl = $config->get('nva_token_url');
      $apiClient = new APIClient($client_id, $client_secret, $config->get('nva_hostname'), $tokenUrl);
      $apiClient->authenticate();
    }
    return $apiClient;
  }

}
