<?php

namespace Drupal\o365\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of Microsoft 365 connector entities.
 */
class O365ConnectorListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    $header['status'] = $this->t('Status');
    $header['callback'] = $this->t('Callback URL');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\o365\O365ConnectorInterface $entity */
    $row['label'] = $entity->label();
    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');
    $row['callback'] = Url::fromRoute(
      'o365_sso.login_callback_controller_callback',
      ['o365_connector' => $entity->id()],
      ['absolute' => TRUE]
    )->toString();

    return $row + parent::buildRow($entity);
  }

}
