<?php

namespace Drupal\o365;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides as interface defining a SocialO365 entity.
 */
interface O365ConnectorInterface extends ConfigEntityInterface {

  /**
   * Get the client ID.
   */
  public function getClientId(): string;

  /**
   * Get the client secret.
   */
  public function getClientSecret(): string;

  /**
   * Get the tenant ID.
   */
  public function getTenantId(): string;

  /**
   * Get the redirect url.
   */
  public function getRedirectLogin(): string;

  /**
   * Gets auth scopes.
   */
  public function getAuthScopes(): string;

}
