# Microsoft 365 Connector module

## INTRODUCTION

The Microsoft 365 Connector module gives you a connector service that makes it
possible for developers to easily connect to the Microsoft Graph API.

### More information

* For a full description of the module, visit the project page:
  https://www.drupal.org/project/o365
* To submit bug reports and feature suggestions, or track changes:
  https://www.drupal.org/project/issues/o365
* Documentation can be found here: https://www.drupal.org/docs/contributed-modules/office-365-connector

## REQUIREMENTS

This module requires the following modules (downloaded via composer.json):

* OAuth2 Client module (https://www.drupal.org/project/oauth2_client)
* External Authentication module (https://www.drupal.org/project/externalauth)
* Microsoft Graph Library for PHP (https://github.com/microsoftgraph/msgraph-sdk-php)
* Mimey used for conversion of mime types (https://github.com/Xantios/mimey)

## INSTALLATION

* Install as you would normally install a contributed Drupal module. Visit
  https://www.drupal.org/docs/8/extending-drupal-8/installing-drupal-8-modules
  for further information.

## CONFIGURATION

* Configure the user permissions in Administration » People » Permissions

* Create an app in your Microsoft Portal (https://portal.azure.com/). Be sure
  to use the url "https://www.example.com/o365/callback" as your redirect url.
  This is needed for login purposes.

* Provide your app data in the settings.php as the provided example below:
```php
  // Microsoft 365 connectors.
  $settings['o365'] = [
    'default' => [
        'client_id' => 'client_id_string',
        'client_secret' => 'client_secret_string',
        'tenant_id' => 'tenant_id_string_or_common',
     ],
     'second_connector' => [
        'client_id' => 'second_connector_client_id_string',
        'client_secret' => 'second_connector_client_secret_string',
        'tenant_id' => 'second_connector_tenant_id_string_or_common',
      ],
  ];
```

> **Important:** Arrays keys, like `second_connector` and `default` must match the
entity IDs on the Microsoft 365 connectors page (`/admin/config/system/o365/settings/o365-connectors`).

* Enter your app data on the API settings page: Configuration > System >
  Microsoft 365 Settings > API settings (or
  https://www.example.com/admin/config/system/o365/settings/api).

* Optionally enable Verbose logging on the settings page: Configuration >
  System > Microsoft 365 Settings (or
  https://www.example.com/admin/config/system/o365/settings).

## DEVELOPMENT
### CSS
When compiling CSS you can use the following command from the root folder of the module: `sass --watch static-src:static --style compressed`

## MAINTAINERS

* Fabian de Rijk - https://www.drupal.org/u/fabianderijk

## Sponsors

### Finalist
Finalist implements Drupal CMS based on the needs of our customers: smart &
lightweight to highly complex & sophisticated websites, communities and
portals. Through our proven project approach and high involvement we are
able to produce websites within a stipulated time period. Regardless of
complexity or scale, we guarantee full service, a risk-free project
approach, transparent pricing models and vendor independency.
