<?php

namespace Drupal\o365_contacts\Plugin\Block;

use Drupal\o365\Block\O365BlockBase;

/**
 * Provides a 'Contact Search' block.
 *
 * @Block(
 *   id = "o365_contacts",
 *   admin_label = @Translation("Contact Search"),
 *   category = @Translation("Microsoft 365")
 * )
 */
class SearchContactBlock extends O365BlockBase {

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * {@inheritdoc}
   */
  public function build() {
    $form = $this->formBuilder->getForm('\Drupal\o365_contacts\Form\SearchContactForm');
    return $form;
  }

}
