<?php

namespace Drupal\o365_sharepoint_file\Plugin\Block;

use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\o365\Block\O365BlockBase;
use Drupal\o365\GraphService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a 'Sharepoint File Search' block.
 *
 * @Block(
 *   id = "o365_sharepoint_file",
 *   admin_label = @Translation("Sharepoint file search"),
 *   category = @Translation("Microsoft 365")
 * )
 */
class SharepointSearchBlock extends O365BlockBase implements ContainerFactoryPluginInterface {

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected FormBuilderInterface $formBuilder;

  /**
   * Constructs a SharepointSearchBlock object.
   *
   * @param array $configuration
   *   The plugin configuration.
   * @param string $plugin_id
   *   The plugin ID.
   * @param mixed $plugin_definition
   *   The plugin definition.
   * @param \Drupal\o365\GraphService $graphService
   *   The graph service.
   * @param \Drupal\Core\Form\FormBuilderInterface $formBuilder
   *   The form builder.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, GraphService $graphService, FormBuilderInterface $formBuilder) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $graphService);
    $this->formBuilder = $formBuilder;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    // @phpstan-ignore-next-line
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('o365.graph'),
      $container->get('form_builder')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    return $this->formBuilder
      ->getForm('Drupal\o365_sharepoint_file\Form\SearchSharepointForm');
  }

}
