<?php

/**
 * @file
 * Post update functions for the Microsoft 365 - SSO module.
 */

/**
 * Update the default link text configuration.
 */
function o365_sso_post_update_update_default_link_text_config() {
  $config = \Drupal::configFactory()->getEditable('o365_sso.settings');
  $link_text = (string) $config->get('link_text');
  if (!$link_text || !str_contains($link_text, '@connector')) {
    $config
      ->set('link_text', 'Login with @connector')
      ->save(TRUE);
  }
}
