<?php

namespace Drupal\o365_sso\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\o365\AuthenticationServiceInterface;
use Drupal\o365\O365ConnectorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Login controller, let the user actually login.
 */
class LoginController extends ControllerBase {

  /**
   * The authentication service, used to handle all kinds of auth stuff.
   *
   * @var \Drupal\o365\AuthenticationServiceInterface
   */
  protected AuthenticationServiceInterface $authenticationService;

  /**
   * Constructs a new LoginController object.
   *
   * @param \Drupal\o365\AuthenticationServiceInterface $authenticationService
   *   The AuthenticationService definition.
   */
  public function __construct(AuthenticationServiceInterface $authenticationService) {
    $this->authenticationService = $authenticationService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    /** @var \Drupal\o365\AuthenticationServiceInterface $authentication */
    $authentication = $container->get('o365.authentication');
    // @phpstan-ignore-next-line
    return new static($authentication);
  }

  /**
   * Carry out the default login.
   */
  public function loginDefault() {
    $storage = $this->entityTypeManager()->getStorage('o365_connector');
    $o365Connectors = $storage->loadMultiple();
    if (count($o365Connectors) > 0) {
      /** @var \Drupal\o365\O365ConnectorInterface $defaultO365Connector */
      $defaultO365Connector = $o365Connectors['default'] ?? reset($o365Connectors);
      return $this->login($defaultO365Connector);
    }

    throw new NotFoundHttpException('Please create a default Microsoft 365 connector.');
  }

  /**
   * Login.
   *
   * @param \Drupal\o365\O365ConnectorInterface $o365_connector
   *   The o365 connector.
   *
   * @return mixed
   *   Return the data.
   */
  public function login(O365ConnectorInterface $o365_connector): mixed {
    return $this->authenticationService->redirectToAuthorizationUrl($o365_connector);
  }

}
