<?php

namespace Drupal\o365_sso;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultAllowed;
use Drupal\Core\Access\AccessResultForbidden;
use Drupal\Core\Session\AccountInterface;

/**
 * Access checker for the login page.
 */
class O365CheckLoginAccess {

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected AccountInterface $currentUser;

  /**
   * Constructs an O365CheckLoginAccess object.
   *
   * @param \Drupal\Core\Session\AccountInterface $currentUser
   *   The current user.
   */
  public function __construct(AccountInterface $currentUser) {
    $this->currentUser = $currentUser;
  }

  /**
   * Check if a user is anonymous and grant access, else deny.
   *
   * @return \Drupal\Core\Access\AccessResultAllowed|\Drupal\Core\Access\AccessResultForbidden
   *   If a user has access.
   */
  public function checkAccess(): AccessResultForbidden|AccessResultAllowed {
    return $this->currentUser->isAnonymous() ? AccessResult::allowed() : AccessResult::forbidden('This path is only accessible for anonymous users');
  }

}
