<?php

/**
 * @file
 * Hook examples and explanations.
 */

/**
 * @addtogroup hooks
 */

use Drupal\o365\O365ConnectorInterface;

/**
 * Create a list of authorization scopes.
 *
 * @param array $scopes
 *   An array of authorization scopes.
 */
function hook_o365_auth_scopes(array &$scopes, O365ConnectorInterface $connector) {
  $scopes[] = 'scope_name';
  $scopes[] = 'User.Read';

  if ($connector->id() === 'custom_id') {
    $scopes[] = 'People.Read';
  }
}
