<?php

namespace Drupal\o365;

/**
 * The interface for the AuthenticationService.
 */
interface AuthenticationServiceInterface {

  /**
   * Redirect the user to the correct Microsoft pages for OAuth2.
   *
   * @param \Drupal\o365\O365ConnectorInterface $o365_connector
   *   The o365_connector entity type.
   *
   * @return mixed
   *   The response, probably a redirect.
   */
  public function redirectToAuthorizationUrl(O365ConnectorInterface $o365_connector);

  /**
   * Generate and save the access token.
   *
   * @param string $code
   *   The code we got from Microsoft.
   * @param \Drupal\o365\O365ConnectorInterface $o365_connector
   *   The o365_connector entity type.
   * @param string $redirect
   *   An url where to redirect to.
   *
   * @throws \Drupal\Core\TempStore\TempStoreException
   * @throws \League\OAuth2\Client\Provider\Exception\IdentityProviderException
   */
  public function setAccessToken(string $code, O365ConnectorInterface $o365_connector, string $redirect = '');

  /**
   * Get the access token for the user.
   *
   * @param bool $login
   *   If we want to log in the user if there is no token.
   *
   * @return string|false
   *   The access token or false when no token is provided.
   *
   * @throws \Drupal\Core\TempStore\TempStoreException
   * @throws \League\OAuth2\Client\Provider\Exception\IdentityProviderException
   */
  public function getAccessToken($login = FALSE);

  /**
   * Save the auth data from the url parameters in the user session storage.
   *
   * @throws \Drupal\Core\TempStore\TempStoreException
   */
  public function saveAuthDataFromUrl() :void;

  /**
   * Check if a user is logged in via Office.
   *
   * @return string|bool
   *   The users ID or FALSE if not logged in via Office.
   */
  public function checkForOfficeLogin();

}
