<?php

namespace Drupal\o365;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access controller for the Microsoft 365 connector entity.
 *
 * @see \Drupal\o365\Entity\O365Connector.
 */
class O365ConnectorAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermissions($account, [
          'access o365 connectors',
          $this->entityType->getAdminPermission(),
        ], 'OR');

      case 'update':
        return AccessResult::allowedIfHasPermissions($account, [
          'edit o365 connector',
          $this->entityType->getAdminPermission(),
        ], 'OR');

      case 'delete':
        if ($entity->isNew()) {
          return AccessResult::forbidden()->addCacheableDependency($entity);
        }
        return AccessResult::allowedIfHasPermissions($account, [
          'delete o365 connector',
          $this->entityType->getAdminPermission(),
        ], 'OR');

      default:
        return parent::checkAccess($entity, $operation, $account);
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions($account, [
      'create o365 connector',
      $this->entityType->getAdminPermission(),
    ], 'OR');
  }

}
