<?php

namespace Drupal\o365;

use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Messenger\Messenger;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Psr\Log\LoggerInterface;

/**
 * Our custom Logger service.
 */
class O365LoggerService implements O365LoggerServiceInterface {

  /**
   * Drupal\Core\Logger\LoggerChannelFactoryInterface definition.
   */
  protected LoggerChannelFactoryInterface $loggerFactory;

  /**
   * The logger channel.
   */
  protected LoggerInterface $logger;

  /**
   * The drupal messenger.
   */
  protected Messenger $messenger;

  /**
   * Constructs a new O365LoggerService object.
   *
   * @param \Drupal\Core\Logger\LoggerChannelFactoryInterface $logger_factory
   *   The LoggerChannelFactoryInterface definition.
   * @param \Drupal\Core\Messenger\Messenger $messenger
   *   The Messenger definition.
   */
  public function __construct(LoggerChannelFactoryInterface $logger_factory, Messenger $messenger) {
    $this->loggerFactory = $logger_factory;
    $this->logger = $this->loggerFactory->get('o365');
    $this->messenger = $messenger;
  }

  /**
   * {@inheritdoc}
   */
  public function log($message, $severity) {
    $this->logger->log($severity, $message);
    $this->showDrupalMessage($message, $severity);
  }

  /**
   * {@inheritdoc}
   */
  public function debug(TranslatableMarkup $message) {
    $this->logger->debug($message);
  }

  /**
   * Render a drupal message.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $message
   *   The message to print.
   * @param string $severity
   *   The severity of the message.
   */
  private function showDrupalMessage($message, string $severity) {
    if ($severity === 'error') {
      $this->messenger->addError($message);
    }
    else {
      $this->messenger->addMessage($message);
    }
  }

}
