<?php

namespace Drupal\o365_profile\Plugin\Block;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\externalauth\AuthmapInterface;
use Drupal\o365\Block\O365UncachedBlockBase;
use Drupal\o365\GraphService;
use Drupal\o365_profile\O365ProfileTeamsService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a 'Teams Links' block.
 *
 * @Block(
 *   id = "o365_profile_teams_links",
 *   admin_label = @Translation("Microsoft 365 - Teams Links"),
 *   category = @Translation("Microsoft 365")
 * )
 */
final class TeamsLinksBlock extends O365UncachedBlockBase implements ContainerFactoryPluginInterface {

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected GraphService $graphService,
    protected O365ProfileTeamsService $o365ProfileTeams,
    protected AuthmapInterface $authmap,
    protected RouteMatchInterface $routeMatch,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $graphService);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('o365.graph'),
      $container->get('o365_profile.teams'),
      $container->get('externalauth.authmap'),
      $container->get('current_route_match')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $user = $this->routeMatch->getParameter('user');
    $build = [];
    if ($user && $this->authmap->get($user->id(), 'o365_sso')) {
      $build['#attached'] = [
        'library' => [
          'o365/icons',
          'o365_profile/teams_block',
        ],
      ];
      $build['#cache'] = [
        'tags' => [
          'user:' . $user->id(),
        ],
      ];

      $call = $this->o365ProfileTeams->generateTeamsLink($user, 'call');
      $chat = $this->o365ProfileTeams->generateTeamsLink($user, 'chat');
      $video = $this->o365ProfileTeams->generateTeamsLink($user, 'video');

      if ($call) {
        $build['o365_profile_teams_call'] = $call;
      }

      if ($chat) {
        $build['o365_profile_teams_chat'] = $chat;
      }

      if ($video) {
        $build['o365_profile_teams_video'] = $video;
      }
    }

    return $build;
  }

}
