<?php

namespace Drupal\o365\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for the o365 module.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['o365.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('o365.settings');

    $form['verbose_logging'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable verbose logging'),
      '#default_value' => $config->get('verbose_logging'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    parent::submitForm($form, $form_state);

    $this->config('o365.settings')
      ->set('verbose_logging', $form_state->getValue('verbose_logging'))
      ->save();
  }

}
