<?php

declare(strict_types=1);

namespace Drupal\Tests\o365\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test module installation.
 *
 * @group o365
 */
final class InstallTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'o365',
    'oauth2_client',
    'externalauth',
  ];

  /**
   * Test module install.
   */
  public function testInstall(): void {
    $admin_user = $this->drupalCreateUser(['access o365 settings page']);
    $this->drupalLogin($admin_user);
    $this->drupalGet('/admin/config/system/o365/settings');
    $this->assertSession()->responseContains('Microsoft 365 Settings');
  }

}
