<?php

namespace Drupal\oauth\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\user\UserInterface;

/**
 * Checks access for oauth.
 */
class CustomAccessCheck implements AccessInterface {

  /**
   * Check if the user can administer their own or other's keys.
   *
   * @param \Drupal\user\UserInterface $user
   *   User to check access for.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   Run access checks for this account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result object.
   */
  public function access(UserInterface $user, AccountInterface $account): AccessResultInterface {
    return AccessResult::allowedIfHasPermission($account, 'administer consumers')
      ->orIf(
        AccessResult::allowedIf($user->id() == $account->id())
          ->andIf(AccessResult::allowedIfHasPermission($account, 'access own consumers')))
      ->addCacheableDependency($account)
      ->cachePerPermissions();
  }

}
