<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Service;

use Drupal\oauth_client\Entity\GrantType;
use Drupal\oauth_client\Entity\OauthClientRequestTypeInterface;

/**
 * OAuth2 Client Request Type helper service.
 */
class OauthClientRequestTypeHelper {

  /**
   * Checks if an OAuth2 Client Request Type entity is well-formed.
   *
   * @param \Drupal\oauth_client\Entity\OauthClientRequestTypeInterface $type
   *   The bundle entity.
   *
   * @return bool
   *   Whether the OAuth2 Client Request Type entity is well-formed.
   */
  public function isOauthClientRequestTypeValid(OauthClientRequestTypeInterface $type): bool {
    return $type->getScope() !== NULL && (
        $type->isEnabledGrantType(GrantType::ClientCredentials) ||
        $type->isEnabledGrantType(GrantType::AuthorizationCode)
      );
  }

}
