<?php

declare(strict_types=1);

namespace Drupal\Tests\oauth_client\Unit\Hook;

use Drupal\consumers\Entity\ConsumerInterface;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\Query\QueryInterface;
use Drupal\oauth_client\Entity\OauthClientRequestInterface;
use Drupal\oauth_client\Hook\OauthClientEntityDeleteHandler;
use Drupal\Tests\UnitTestCase;

/**
 * Tests for OauthClientEntityDeleteHandler.
 *
 * @group oauth_client
 */
class OauthClientEntityDeleteHandlerTest extends UnitTestCase {

  /**
   * Tests deleting consumer when oauth_client_request is deleted.
   */
  public function testDeletesConsumerWhenRequestDeleted(): void {
    $consumer = $this->createMock(ConsumerInterface::class);
    $consumer->expects($this->once())->method('delete');

    $request = $this->createMock(OauthClientRequestInterface::class);
    $request->method('getClient')->willReturn($consumer);

    $entityTypeManager = $this->createMock(EntityTypeManagerInterface::class);
    $handler = new OauthClientEntityDeleteHandler($entityTypeManager);

    $handler->entityDelete($request);
  }

  /**
   * Tests deleting requests when consumer is deleted.
   */
  public function testDeletesRequestsWhenConsumerDeleted(): void {
    $consumer = $this->createMock(ConsumerInterface::class);
    $consumer->method('id')->willReturn('123');

    $query = $this->createMock(QueryInterface::class);
    $query->method('condition')->willReturnSelf();
    $query->method('accessCheck')->willReturnSelf();
    $query->method('execute')->willReturn(['req1', 'req2']);

    $storage = $this->createMock(EntityStorageInterface::class);
    $storage->method('getQuery')->willReturn($query);
    $storage->method('loadMultiple')->willReturn([]);
    $storage->expects($this->once())->method('delete');

    $entityTypeManager = $this->createMock(EntityTypeManagerInterface::class);
    $entityTypeManager->method('getStorage')->willReturn($storage);

    $handler = new OauthClientEntityDeleteHandler($entityTypeManager);
    $handler->entityDelete($consumer);
  }

}
