<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Entity;

/**
 * Defines the status values for OAuth Client Request entities.
 */
enum OauthClientRequestStatus: string {

  case Pending = 'pending';
  case Active = 'active';
  case Rejected = 'rejected';

  /**
   * Returns human-readable options for the status values.
   *
   * @return array
   *   An array of status options keyed by status value.
   */
  public static function getOptions(): array {
    return [
      self::Pending->value => t('Pending'),
      self::Active->value => t('Active'),
      self::Rejected->value => t('Rejected'),
    ];
  }

}
