<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Entity;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * OAuth2 Client Request Type entity list builder.
 */
class OauthClientTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    return [
      $this->t('Label'),
      $this->t('ID'),
    ] + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    return [
      $entity->label(),
      [
        'data' => [
          '#markup' => $entity->id(),
          '#prefix' => '<pre>',
          '#suffix' => '</pre>',
        ],
      ],
    ] + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity): array {
    $operations = parent::getDefaultOperations($entity);

    $operations['edit'] = [
      'title' => $this->t('Edit'),
      'url' => $entity->toUrl(),
      'weight' => 10,
    ];

    return $operations;
  }

}
