<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Event;

use Drupal\oauth_client\Entity\NotificationType;
use Drupal\oauth_client\Entity\OauthClientRequestInterface;

/**
 * Event for sending notifications.
 */
class NotificationEvent {

  public function __construct(
    protected OauthClientRequestInterface $oauthClientRequest,
    protected NotificationType $action,
  ) {}

  /**
   * Returns the OAuth client request entity.
   *
   * @return \Drupal\oauth_client\Entity\OauthClientRequestInterface
   *   The OAuth client request entity.
   */
  public function getOauthClientRequest(): OauthClientRequestInterface {
    return $this->oauthClientRequest;
  }

  /**
   * Returns the action triggering the notification.
   *
   * @return \Drupal\oauth_client\Entity\NotificationType
   *   The action triggering the notification. One of the NotificationType
   *   constants.
   */
  public function getAction(): NotificationType {
    return $this->action;
  }

}
