<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\Menu;

use Drupal\Core\Menu\LocalTaskDefault;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * User's Oauth2 Client Requests task link with dynamic parameter.
 */
class UserRequests extends LocalTaskDefault {

  /**
   * {@inheritdoc}
   */
  public function getRouteParameters(RouteMatchInterface $route_match): array {
    $routeParameters = array_filter([
      'user' => $route_match->getRawParameters()->get('user'),
    ]);
    return $routeParameters;
  }

}
