<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\views\filter;

use Drupal\oauth_client\Entity\OauthClientRequestStatus as StatusEnum;
use Drupal\views\Attribute\ViewsFilter;
use Drupal\views\Plugin\views\filter\InOperator;

/**
 * Filter plugin for Oauth2 Client Request entity status.
 *
 * @ViewsFilter("oauth_client_request_status")
 */
#[ViewsFilter("oauth_client_request_status")]
class OauthClientRequestStatus extends InOperator {

  /**
   * {@inheritdoc}
   */
  public function getValueOptions(): array {
    // We have to set this property - due to a bad design in the parent class.
    return $this->valueOptions = StatusEnum::getOptions();
  }

}
