# OAuth2 Client

Provides a user-facing UI and workflow for requesting and managing OAuth2
client applications (clients) in Drupal. It
integrates with the Simple OAuth module to allow site users to:

- Request new OAuth2 clients with preconfigured scopes.
- Automatically generate a permission for each allowed scope.
- Have requests approved by privileged users (client managers).
- Manage their own approved clients (rename label, rotate secret) or delete
  pending requests.

## Requirements

- Drupal core: ^10.4 or ^11
- Module: [Simple OAuth](https://www.drupal.org/project/simple_oauth) (
  drupal/simple_oauth ^6)
  - Simple OAuth provides the OAuth2 server (uses the clients module for
    client entities).

## Installation

Install the module as usual—via composer:

- `composer require drupal/oauth_client`
- `drush en oauth_client -y`

## Configuration and Usage

Setting up the module consists of 3 steps:

* Define one or more scopes in Simple OAuth.
* Create a client request type and filter the scopes the clients will be
  limited to.
* Assign permissions to roles that should be able to request clients.

### Scopes

Scopes are defined in the Simple OAuth module. See the
[Simple OAuth module page](https://www.drupal.org/project/simple_oauth) for
more information.

### Client Request Type

A client request type is a new entity type that represents the request for a
client. The request type is moderated and can be approved or denied by a
manager.

To create a client request type:

* Navigate to `/admin/config/services/client/oauth-client`
* Click "New client request type"
* Provide a label
* Filter the grant types and the scopes that you want to allow for the client.
* Click "Save"

### Permissions

The module uses permission-based access control.

When a client request type is created, a permission is automatically created
that allows controlling who can request the client type. The permission pattern
is: `Apply for <client request type label> oauth2 client`. Give this permission
to the roles that should be able to request clients.

The module also provides a "Manage OAuth2 clients" permission that allows
managers to manage clients.

### UI

#### Requesting a Client

A new tab is added in the secondary tabs of the user account page. Under
"Edit" > "OAuth2 client requests" the user can press "Request client" and fill
in the required fields.

#### Managing Clients

Privileged users can manage clients' requests at
`/admin/config/services/consumer/oauth-client-request` where they can view,
edit, delete or approve/reject them.

By approving a client request, a new client is created with the appropriate
settings. After that, Simple OAuth will work as usual.

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the
recommended tool for contributing to the module.
The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering tools to set up and
test the module.

### Install DDEV

* Install a Docker provider by following the
  DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/)
  instructions for your operating system.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/),
  using the documentation that best fits your OS.
* DDEV is used mostly via CLI commands.
  [Configure shell completion & auto complete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/)
  according to your
  environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical
  step for testing and debugging your module. Remember, the website runs inside
  Docker, so pay attention to these configurations:
  - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
  - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/)
    PhpStorm and VS Code
    for step debugging.
  - Profiling
    with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/), [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/),
    and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Set up the project

Normally, you check out the code from an
[issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):

### Start DDEV

Inside the cloned project, run:

```shell
ddev start
```

This command will start the Docker containers and apply all configurations.

### Install dependencies

```shell
ddev poser
```

This installs the PHP dependencies. Note that this is a replacement for the
Composer _install_ command that knows how to
bundle Drupal core with the module. Read more about this command
at [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands).

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this
command at the
same [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands)
link.
Note: As soon as `vendor/autoload.php` is generated, this command runs
automatically on every `ddev start`.

Run this command manually after adding new directories or files to the root of
the module.

```shell
ddev exec "cd web/core && yarn install"
```

Installs Node.js dependencies. This is required for the `ddev eslint` command.

### Install Drupal

```shell
ddev install
```

This installs Drupal and enables the module.

### Changing the Drupal core and PHP versions

* Create a `.ddev/config.local.yaml` file.
* Set the desired Drupal core and PHP versions. For example:
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.5
  php_version: "8.1"
  ```
* Run `ddev restart`

### Run tests

* `ddev phpunit` — run PHPUnit tests
* `ddev phpcs` — run PHP coding standards checks
* `ddev phpcbf` — fix coding standards issues
* `ddev phpstan` — run PHP static analysis
* `ddev eslint` — run ESLint on JavaScript and YAML files

## Security and Support

- Please report security issues via the Drupal.org project issue queue and
  follow the Drupal Security Team’s
  processes: https://www.drupal.org/security-team/reporting
- General support and feature requests: use the project issue
  queue: https://www.drupal.org/project/issues/oauth_client

## Maintainers and Credits

- Module page: https://www.drupal.org/project/oauth_client

## License

GPL-2.0-or-later. See the LICENSE file distributed with this project or
visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
