<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Entity;

/**
 * Grant types.
 */
enum GrantType: string {

  case ClientCredentials = 'client_credentials';
  case AuthorizationCode = 'authorization_code';

  /**
   * Returns the grant type label.
   *
   * @return string|\Stringable
   *   Grant type label.
   */
  public function label(): string|\Stringable {
    return match ($this) {
      self::ClientCredentials => t('Client credentials'),
      self::AuthorizationCode => t('Authorization code'),
    };
  }

}
