<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\Menu;

use Drupal\Core\Menu\LocalActionDefault;
use Drupal\Core\Routing\RouteProviderInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\oauth_client\Access\AccessTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Custom action class allowing a customizable title.
 */
class AddRequestAction extends LocalActionDefault {

  use AccessTrait;
  use StringTranslationTrait;

  public function __construct(
    array $configuration,
    $pluginId,
    $pluginDefinition,
    RouteProviderInterface $routeProvider,
    protected readonly AccountInterface $currentUser,
  ) {
    parent::__construct($configuration, $pluginId, $pluginDefinition, $routeProvider);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('router.route_provider'),
      $container->get('current_user'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getTitle(?Request $request = NULL): string|\Stringable {
    $title = parent::getTitle($request);

    if (!$this->isManager($this->currentUser)) {
      return $title;
    }

    return $this->t('New client');
  }

}
