<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\Validator\Constraint;

/**
 * Validation constraint for the status transitions.
 */
#[\Drupal\Core\Validation\Attribute\Constraint(
  id: 'oauth_client_request_transition_constraint',
  label: new TranslatableMarkup('Oauth Client Request transition constraint', [], ['context' => 'Validation']),
  type: ['string']
)]
class OauthClientRequestTransitionConstraint extends Constraint {

  /**
   * The status transition error message.
   *
   * @var string
   */
  public string $transitionMessage = 'The transition from status "@from" to "@to" is not allowed.';

  /**
   * The reject reason is empty message.
   *
   * @var string
   */
  public string $rejectEmptyMessage = 'Reject reason is required when rejecting a request.';

}
