<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\Validation\Constraint;

use Drupal\oauth_client\Entity\OauthClientRequestStatus;

/**
 * Class that defines the allowed status transitions.
 */
final class OauthClientRequestTransitionHelper {

  /**
   * Returns allowed next statuses based on current status.
   *
   * @param \Drupal\oauth_client\Entity\OauthClientRequestStatus $current
   *   The current status.
   *
   * @return array<string>
   *   An array of allowed next status values.
   */
  public static function getAllowedTransitions(OauthClientRequestStatus $current): array {
    // Allowed transitions:
    // pending > active,
    // pending > rejected,
    // rejected > active.
    return match ($current) {
      OauthClientRequestStatus::Pending => [
        OauthClientRequestStatus::Active->value,
        OauthClientRequestStatus::Rejected->value,
      ],
      OauthClientRequestStatus::Rejected => [
        OauthClientRequestStatus::Active->value,
      ],
      default => [],
    };
  }

}
