<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Plugin\views\field;

use Drupal\oauth_client\Entity\OauthClientRequestInterface;
use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Displays the Oauth2 Client Request's scope (fetched from request type).
 *
 * @ViewsField("oauth_client_request_scope")
 */
#[ViewsField("oauth_client_request_scope")]
class OauthClientRequestScope extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function query(): void {}

  /**
   * {@inheritdoc}
   */
  public function usesGroupBy(): bool {
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function clickSortable(): bool {
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values): ?string {
    $entity = $this->getEntity($values);
    if (!$entity instanceof OauthClientRequestInterface) {
      return NULL;
    }
    return $entity->get($entity->getEntityType()->getKey('bundle'))->entity->get('scope');
  }

}
