<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\oauth_client\Controller\OauthClientRequestAddController;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters the add-page route.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    if ($route = $collection->get('entity.oauth_client_request.add_page')) {
      // Use our controller.
      $route->setDefault('_controller', OauthClientRequestAddController::class . '::addPage');
      $route->setDefault('_title_callback', OauthClientRequestAddController::class . '::addTitle');

      // Add the 'user' route parameter.
      $parameters = $route->getOption('parameters') ?? [];
      $parameters['user'] = ['type' => 'entity:user'];
      $route->setOption('parameters', $parameters);
    }

    // Enable the "_admin_route" option on the Oauth2 Client Request (Views)
    // page. Unfortunately, activating the "Administration theme" option removes
    // local task links somehow.
    $usersRequestsRoute = $collection->get('view.oauth_client_request.user_requests');
    if ($usersRequestsRoute) {
      $usersRequestsRoute
        ->setOption('_admin_route', TRUE)

        ->setRequirement('_oauth_client_manager_or_self', 'TRUE');
    }
  }

}
