<?php

declare(strict_types=1);

namespace Drupal\Tests\oauth_client\Functional;

use Drupal\Tests\BrowserTestBase;
use GuzzleHttp\ClientInterface;

/**
 * A base class for functional tests of the OAuth Client module.
 */
class OauthClientFunctionalTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['block', 'oauth_client', 'views'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * The HTTP client to use for making requests.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected ClientInterface $httpClient;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->generateKeys();
  }

  /**
   * Generates OAuth2 keys and configures the module to use them.
   */
  protected function generateKeys(): void {
    \Drupal::service('simple_oauth.key.generator')->generateKeys(DRUPAL_ROOT);

    $this->config('simple_oauth.settings')
      ->set('private_key', DRUPAL_ROOT . '/private.key')
      ->set('public_key', DRUPAL_ROOT . '/public.key')
      ->save();
  }

}
