# OAuth2 Client

Provides a user-facing UI and workflow for requesting and managing OAuth2 client applications (Consumers) in Drupal. It integrates with the Simple OAuth module to allow site users to:

- Request a new OAuth2 client for a specific "umbrella" scope.
- Have requests approved by privileged users (client managers).
- Manage their own approved clients (rename label, rotate secret) or delete pending requests.

Currently, only the Client Credentials grant type is supported for requested clients.

**NOTE:** The 'Authorization Code' grant type is not supported yet because it needs [this change](https://www.drupal.org/i/3398468) to be adopted by the [Simple OAuth (OAuth2) & OpenID Connect](https://www.drupal.org/project/simple_oauth) module.


## Requirements

- Drupal core: ^10.4 or ^11
- Module: [Simple OAuth](https://www.drupal.org/project/simple_oauth) (drupal/simple_oauth ^6)
  - Simple OAuth provides the OAuth2 server (uses the Consumers module for client entities).


## Installation

Install the module as usual - via composer:
- `composer require drupal/oauth_client`
- `drush en oauth_client -y`

No additional configuration forms are required to enable basic functionality.


## Configuration and Usage

This module does not have any specific configuration. It leverages the existing Simple OAuth configuration for scopes
and client settings.

After defining scopes in Simple OAuth, assign the appropriate permissions to roles that should be able to request
clients for those scopes. Users with the "Manage OAuth2 clients" permission can create and manage clients directly.

Users can manage their OAuth2 clients via their user account page:
- Navigate to `/user/{user}/edit/oauth` (or via the "Edit" tab on their account page).
- From there, they can request a new client, edit existing clients (rename, rotate secret), or delete clients.

Important implementation note:
For regular users, newly requested clients are created as non-confidential (confidential = FALSE) to keep them
effectively disabled until a manager approves them. Client Credentials flow in Simple OAuth requires
`confidential = TRUE`. Managers can create clients directly as confidential.


## Grant Type Support

Only the Client Credentials grant type is supported for requested clients.


## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined and unified development process, is the recommended tool for contributing to the module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib) addon makes it easy to develop a Drupal module by offering tools to set up and test the module.

### Install DDEV

* Install a Docker provider by following the DDEV [Docker Installation](https://ddev.readthedocs.io/en/stable/users/install/docker-installation/) instructions for your operating system.
* [Install DDEV](https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/), using the documentation that best fits your OS.
* DDEV is used mostly via CLI commands. [Configure shell completion & autocomplete](https://ddev.readthedocs.io/en/stable/users/install/shell-completion/) according to your environment.
* Configure your IDE to take advantage of the DDEV features. This is a critical step for testing and debugging your module. Remember, the website runs inside Docker, so pay attention to these configurations:
  - [PhpStorm Setup](https://ddev.readthedocs.io/en/stable/users/install/phpstorm/)
  - [Configure](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/step-debugging/) PhpStorm and VS Code for step debugging.
  - Profiling with [xhprof](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xhprof-profiling/), [Xdebug](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/xdebug-profiling/), and [Blackfire](https://ddev.readthedocs.io/en/stable/users/debugging-profiling/blackfire-profiling/).

### Setup the project

Normally, you check out the code from an
[issue fork](https://www.drupal.org/docs/develop/git/using-gitlab-to-contribute-to-drupal/creating-issue-forks):


### Start DDEV

Inside the cloned project, run:

```shell
ddev start
```

This command will start the Docker containers and apply all configurations.

### Install dependencies

```shell
ddev poser
```

This installs the PHP dependencies. Note that this is a replacement for the Composer _install_ command that knows how to bundle Drupal core with the module. Read more about this command at [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands).

```shell
ddev symlink-project
```

This symlinks the module inside `web/modules/custom`. Read more about this command at the same [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands) link.
Note: As soon as `vendor/autoload.php` is generated, this command runs automatically on every `ddev start`.

Run this command manually after adding new directories or files to the root of the module.

```shell
ddev exec "cd web/core && yarn install"
```

Installs Node.js dependencies. This is required for the `ddev eslint` command.

### Install Drupal

```shell
ddev install
```

This installs Drupal and enables the module.

### Changing the Drupal core and PHP versions

* Create a `.ddev/config.local.yaml` file.
* Set the desired Drupal core and PHP versions. For example:
  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.5
  php_version: "8.1"
  ```
* Run `ddev restart`

### Run tests

* `ddev phpunit` — run PHPUnit tests
* `ddev phpcs` — run PHP coding standards checks
* `ddev phpcbf` — fix coding standards issues
* `ddev phpstan` — run PHP static analysis
* `ddev eslint` — run ESLint on JavaScript and YAML files

## Maintainers and Credits

- Module page: https://www.drupal.org/project/oauth_client


## License

GPL-2.0-or-later. See the LICENSE file distributed with this project or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
