<?php

/**
 * @file
 * Documentation for Consumers module APIs.
 */

declare(strict_types=1);

use Drupal\consumers\Entity\ConsumerInterface;
use Drupal\user\UserInterface;

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Sends a message when a new client is requested.
 *
 * @param \Drupal\consumers\Entity\ConsumerInterface $client
 *   The client entity.
 * @param \Drupal\user\UserInterface $user
 *   The user requesting the new client.
 * @param string $reason
 *   User entered string with the reason for an OAuth2 client.
 */
function hook_oauth_client_request(ConsumerInterface $client, UserInterface $user, string $reason): void {
  if ($user->id() == \Drupal::currentUser()->id()) {
    \Drupal::service('plugin.manager.mail')->mail(
      'my_module',
      'oauth_client_request',
      'moderator@example.com',
      'en',
    );
  }
}

/**
 * @} End of "addtogroup hooks".
 */
