<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Access;

use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access check service of Oauth Client routes.
 */
readonly class OauthClientManagerOrSelf implements AccessInterface {

  use AccessTrait;

  /**
   * Checks access to an oauth_client route.
   *
   * Account must be a manager, or the same user account as in the route slug.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The route match.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(RouteMatchInterface $routeMatch, AccountInterface $account): AccessResultInterface {
    return $this->managerOrSelfAccessResult($account, $routeMatch);
  }

}
