<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Controller;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\oauth_client\Access\AccessTrait;
use Drupal\user\UserInterface;

/**
 * Controller used for access checks.
 */
class AccessController extends ControllerBase {

  use AccessTrait;

  /**
   * Checks if $account can preform actions on $user requests.
   *
   * @param \Drupal\user\UserInterface $user
   *   The user whose requests are being manipulated.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user which tries to perform actions on $user requests.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access resolution.
   */
  public function accessUserRequests(UserInterface $user, AccountInterface $account): AccessResultInterface {
    return $this->getManagerAccess($account)
      ->orIf(AccessResult::allowedIf($account->id() == $user->id()));
  }

}
