<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Entity;

/**
 * Defines the available notification actions for OAuth Client Requests.
 */
enum NotificationType: string {

  // Sent to managers when a new request is created.
  case Request = 'request';

  // Sent to the requester when their request is approved.
  case Approve = 'approve';

  // Sent to the requester when their request is rejected.
  case Reject = 'reject';

  /**
   * Returns human-readable labels for the actions.
   *
   * @return array
   *   An array of action labels keyed by action value.
   */
  public static function getOptions(): array {
    return [
      self::Request->value => t('Request created'),
      self::Approve->value => t('Request approved'),
      self::Reject->value => t('Request rejected'),
    ];
  }

}
