<?php

declare(strict_types=1);

namespace Drupal\oauth_client;

use Drupal\oauth_client\Entity\OauthClientRequestInterface;

/**
 * Interface for the notification sender service.
 */
interface NotificationSenderInterface {

  /**
   * Handles the logic for request notifications.
   *
   * @param \Drupal\oauth_client\Entity\OauthClientRequestInterface $entity
   *   The OAuth client request entity.
   */
  public function handleRequestNotification(OauthClientRequestInterface $entity): void;

  /**
   * Handles the logic for approval notifications.
   *
   * @param \Drupal\oauth_client\Entity\OauthClientRequestInterface $entity
   *   The OAuth client request entity.
   */
  public function handleApprovalNotification(OauthClientRequestInterface $entity): void;

  /**
   * Handles the logic for rejection notifications.
   *
   * @param \Drupal\oauth_client\Entity\OauthClientRequestInterface $entity
   *   The OAuth client request entity.
   */
  public function handleRejectionNotification(OauthClientRequestInterface $entity): void;

}
