<?php

declare(strict_types=1);

namespace Drupal\oauth_client;

use Drupal\views\EntityViewsData;

/**
 * Provides the views data for the oauth_client_request entity type.
 */
class OauthClientRequestViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    $data = parent::getViewsData();
    $baseTable = $this->entityType->getBaseTable();

    // Status filter can and should be an options select.
    $data[$baseTable]['status']['filter'] = [
      'id' => 'oauth_client_request_status',
    ];

    // Scope is fetched from bundle entity; so the field and also the filter
    // need custom plugin.
    $data[$baseTable]['scope'] = [
      'title' => $this->t('Scope'),
      'help' => $this->t('The scope from the type the @oauth-client-request-label belongs to'),
      'field' => [
        'id' => 'oauth_client_request_scope',
        'field' => 'type',
      ],
      'filter' => [
        'id' => 'oauth_client_request_scope',
        'field' => 'type',
      ],
    ];

    // The user behind the "uid" property is the author of the request entity.
    $data[$baseTable]['uid']['title'] = $this->t('User (author of @label)', [
      '@label' => $this->entityTypeManager->getDefinition('oauth_client_request')->getLabel(),
    ]);
    $data[$baseTable]['uid']['relationship']['label'] = $data[$baseTable]['uid']['title'];
    $data[$baseTable]['uid']['relationship']['title'] = $data[$baseTable]['uid']['title'];
    // The other reference behind the "user" property is the intended owner of
    // the OAuth client.
    // Let's reflect this in the Views field, relationships, filters etc.,
    // otherwise there will be two "User" option on the Views UI.
    $data[$baseTable]['user']['title'] = $this->t('User (author of @label)', [
      '@label' => $this->t('Client'),
    ]);
    $data[$baseTable]['user']['relationship']['label'] = $data[$baseTable]['user']['title'];
    $data[$baseTable]['user']['relationship']['title'] = $data[$baseTable]['user']['title'];

    return $data;
  }

}
