<?php

declare(strict_types=1);

namespace Drupal\oauth_client\Routing;

use Drupal\Core\Entity\Controller\EntityController;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Provides routes for the OAuth Client Request entity.
 */
class OauthClientRequestTypeHtmlRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  public function getRoutes(EntityTypeInterface $entity_type): RouteCollection {
    $collection = parent::getRoutes($entity_type);

    $entityTypeId = $entity_type->id();

    if ($canonicalRoute = $this->getCanonicalRoute($entity_type)) {
      $collection->add("entity.$entityTypeId.canonical", $canonicalRoute);
    }

    return $collection;
  }

  /**
   * {@inheritdoc}
   */
  protected function getCanonicalRoute(EntityTypeInterface $entity_type): ?Route {
    if (!$entity_type->hasLinkTemplate('canonical')) {
      return NULL;
    }

    $entityTypeId = $entity_type->id();
    $route = new Route($entity_type->getLinkTemplate('canonical'));
    // Use the edit form handler, if available, otherwise default.
    $operation = 'default';
    if ($entity_type->getFormClass('edit')) {
      $operation = 'edit';
    }
    $route->setDefaults([
      '_entity_form' => "$entityTypeId.default",
      '_title_callback' => EntityController::class . '::editTitle',
    ])->setRequirement('_entity_access', "$entityTypeId.update")
      ->setOption('parameters', [
        $entityTypeId => ['type' => 'entity:' . $entityTypeId],
      ]);

    return $route;
  }

}
